
#ifndef __Defs_h__
#define __Defs_h__

#include "byteordering.h"

#ifdef __cplusplus
extern "C" { /* assume C declarations for C++ */
#endif

typedef signed char    DGT8;
typedef unsigned char  UDGT8;
typedef signed short   DGT16;
typedef unsigned short UDGT16;
typedef signed long    DGT32;
typedef unsigned long  UDGT32;
typedef double         DGTFLOAT;
typedef void           DGTVOID;
typedef DGT32          DGTBOOL;
typedef DGT32          DGTPOINTER; 


#ifndef FALSE
#define FALSE               0
#endif

#ifndef TRUE
#define TRUE                1
#endif

#ifndef NULL
#ifdef __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif
#endif

/* Futronic API function calling convention definition. */
#if defined _WIN32
#  define FTRAPIPREFIX __declspec(dllimport)
#  define FTRAPI __stdcall
#  define FTR_CBAPI __stdcall
#else
#  define FTRAPIPREFIX
#  define FTRAPI 
#  define FTR_CBAPI 
#endif

//
//Declare pack macros. For non Win32 it is gcc specific definition
//
#if defined _WIN32
#  define FTRPACK 
#else
#  define FTRPACK __attribute__ ((aligned(1),packed)) 
#endif


#ifdef __cplusplus
};
#endif

#endif
